import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:intl/intl.dart';
import 'package:viserpay/core/route/route.dart';
import 'package:viserpay/core/utils/dimensions.dart';
import 'package:viserpay/core/utils/my_color.dart';
import 'package:viserpay/core/utils/my_strings.dart';
import 'package:viserpay/core/utils/style.dart';
import 'package:viserpay/core/utils/util.dart';
import 'package:viserpay/data/controller/auto_payment/paybill_auto_payment_controller.dart';
import 'package:viserpay/data/repo/paybill/pay_bill_repo.dart';
import 'package:viserpay/data/services/api_service.dart';
import 'package:viserpay/view/components/app-bar/custom_appbar.dart';
import 'package:viserpay/view/components/cash-card/balance_box_card.dart';
import 'package:viserpay/view/components/cash-card/title_card.dart';
import 'package:viserpay/view/components/snack_bar/show_custom_snackbar.dart';
import 'package:viserpay/view/screens/pay-bill/widget/paybill_icon_widget.dart';

class PayBillAutoPaymentAmountScreen extends StatefulWidget {
  const PayBillAutoPaymentAmountScreen({super.key});

  @override
  State<PayBillAutoPaymentAmountScreen> createState() => _PayBillAutoPaymentAmountScreenState();
}

class _PayBillAutoPaymentAmountScreenState extends State<PayBillAutoPaymentAmountScreen> {
  @override
  void initState() {
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(PayBillRepo(apiClient: Get.find()));
    final controller = Get.put(PayBillAutoPaymentController(paybillRepo: Get.find()));

    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.setSelectedAutoPayValue(1);
      controller.amountController.clear();
      if (controller.selectedUtils == null) {
        Get.back();
      }
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: MyColor.appBarColor,
      appBar: CustomAppBar(
        title: MyStrings.payBillAutoPayment,
        isTitleCenter: true,
        elevation: 0.09,
      ),
      body: GetBuilder<PayBillAutoPaymentController>(builder: (controller) {
        return SingleChildScrollView(
          physics: const BouncingScrollPhysics(),
          child: Padding(
            padding: Dimensions.defaultPaddingHV,
            child: Column(
              children: [
                const SizedBox(
                  height: Dimensions.space25,
                ),
                TitleCard(
                  title: MyStrings.to.tr,
                  onlyBottom: true,
                  widget: Padding(
                    padding: const EdgeInsets.symmetric(vertical: Dimensions.space12, horizontal: Dimensions.space12),
                    child: Row(
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        BillIcon(
                          imageUrl: controller.selectedUtils?.getImage ?? "",
                          color: MyColor.getSymbolColor(0),
                          radius: 8,
                        ),
                        const SizedBox(
                          width: Dimensions.space10,
                        ),
                        Text(
                          controller.selectedUtils?.name.toString().tr ?? "",
                          style: title.copyWith(fontSize: 16),
                        )
                      ],
                    ),
                  ),
                ),
                const SizedBox(
                  height: Dimensions.space16,
                ),
                TitleCard(
                  title: "${MyStrings.autoPayFrequency.tr} ",
                  onlyBottom: true,
                  widget: Column(
                    children: <Widget>[
                      RadioListTile<int>(
                        title: Text(
                          MyStrings.everyMonth.tr,
                          style: regularLarge,
                        ),
                        subtitle: controller.selectedAutoPayValue != 1
                            ? null
                            : GestureDetector(
                                onTap: () => controller.selectNextAuoPayDateDate(context, autoPayInitialDate: controller.selectedAutoPayDateTime), // Open date picker on tap
                                child: Row(
                                  children: [
                                    RichText(
                                      text: TextSpan(
                                        children: [
                                          TextSpan(
                                            text: "${MyStrings.nextAutoPaymentDate.tr} ",
                                            style: regularDefault.copyWith(
                                              fontSize: Dimensions.fontExtraSmall,
                                            ),
                                          ),
                                          TextSpan(
                                            text: DateFormat('yyyy-MM-dd').format(controller.selectedAutoPayDateTime), // Display selected date
                                            style: regularDefault.copyWith(
                                              fontSize: Dimensions.fontSmall,
                                              color: MyColor.redCancelTextColor, // Set date text color to red
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                    SizedBox(width: 4), // Spacing between text and icon
                                    Icon(
                                      Icons.calendar_month,
                                      color: MyColor.redCancelTextColor,
                                      size: 16, // Icon size to match text
                                    ),
                                  ],
                                ),
                              ),
                        value: 1,
                        groupValue: controller.selectedAutoPayValue,
                        onChanged: (value) {
                          controller.setSelectedAutoPayValue(value ?? 1);
                        },
                      ),
                      RadioListTile<int>(
                        title: Text(
                          MyStrings.every15days.tr,
                          style: regularLarge,
                        ),
                        subtitle: controller.selectedAutoPayValue != 2
                            ? null
                            : GestureDetector(
                                onTap: () => controller.selectNextAuoPayDateDate(context, autoPayInitialDate: controller.selectedAutoPayDateTime), // Open date picker on tap
                                child: Row(
                                  children: [
                                    RichText(
                                      text: TextSpan(
                                        children: [
                                          TextSpan(
                                            text: "${MyStrings.nextAutoPaymentDate.tr} ",
                                            style: regularDefault.copyWith(
                                              fontSize: Dimensions.fontExtraSmall,
                                            ),
                                          ),
                                          TextSpan(
                                            text: DateFormat('yyyy-MM-dd').format(controller.selectedAutoPayDateTime), // Display selected date
                                            style: regularDefault.copyWith(
                                              fontSize: Dimensions.fontSmall,
                                              color: MyColor.redCancelTextColor, // Set date text color to red
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                    SizedBox(width: 4), // Spacing between text and icon
                                    Icon(
                                      Icons.calendar_month,
                                      color: MyColor.redCancelTextColor,
                                      size: 16, // Icon size to match text
                                    ),
                                  ],
                                ),
                              ),
                        value: 2,
                        groupValue: controller.selectedAutoPayValue,
                        onChanged: (value) {
                          controller.setSelectedAutoPayValue(value ?? 2);
                        },
                      ),
                      RadioListTile<int>(
                        title: Text(
                          MyStrings.everyWeek.tr,
                          style: regularLarge,
                        ),
                        subtitle: controller.selectedAutoPayValue != 3
                            ? null
                            : GestureDetector(
                                onTap: () => controller.selectNextAuoPayDateDate(context, autoPayInitialDate: controller.selectedAutoPayDateTime), // Open date picker on tap
                                child: Row(
                                  children: [
                                    RichText(
                                      text: TextSpan(
                                        children: [
                                          TextSpan(
                                            text: "${MyStrings.nextAutoPaymentDate.tr} ",
                                            style: regularDefault.copyWith(
                                              fontSize: Dimensions.fontExtraSmall,
                                            ),
                                          ),
                                          TextSpan(
                                            text: DateFormat('yyyy-MM-dd').format(controller.selectedAutoPayDateTime), // Display selected date
                                            style: regularDefault.copyWith(
                                              fontSize: Dimensions.fontSmall,
                                              color: MyColor.redCancelTextColor, // Set date text color to red
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                    SizedBox(width: 4), // Spacing between text and icon
                                    Icon(
                                      Icons.calendar_month,
                                      color: MyColor.redCancelTextColor,
                                      size: 16, // Icon size to match text
                                    ),
                                  ],
                                ),
                              ),
                        value: 3,
                        groupValue: controller.selectedAutoPayValue,
                        onChanged: (value) {
                          controller.setSelectedAutoPayValue(value ?? 3);
                        },
                      ),
                    ],
                  ),
                ),
                const SizedBox(
                  height: Dimensions.space16,
                ),
                BalanceBoxCard(
                  focusNode: controller.amountFocusNode,
                  textEditingController: controller.amountController,
                  onpress: () {
                    double currntBalance = NumberFormat.decimalPattern().parse(controller.currentBalance).toDouble();

                    if (controller.amountController.text.trim().isNotEmpty) {
                      if (controller.amountController.text.trim().isNotEmpty) {
                        if (MyUtils().balanceValidation(currentBalance: currntBalance, amount: double.tryParse(controller.amountController.text) ?? 0)) {
                          Get.toNamed(RouteHelper.paybillAutoPaymentPinScreen);
                        }
                      } else {
                        CustomSnackBar.error(errorList: [MyStrings.enterAmount]);
                      }
                    } else {
                      CustomSnackBar.error(errorList: [MyStrings.enterAmount]);
                    }
                  },
                ),
                const SizedBox(
                  height: Dimensions.space16,
                ),
              ],
            ),
          ),
        );
      }),
    );
  }
}
